unit dontu;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TDontForm = class(TForm)
    Image1: TImage;
    btnYes: TButton;
    btnNo: TButton;
    btnDont: TButton;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure SetData(const S : String; YesNo : Boolean);
  end;

var
  DontForm: TDontForm;

implementation

{$R *.dfm}

procedure TDontForm.FormCreate(Sender: TObject);
VAR
  NCM : NONCLIENTMETRICS;
  H : Integer;
begin
  // Use the system-specified messagebox font
  FillChar(NCM, SizeOf(NCM), 0);
  NCM.cbSize := SizeOf(NCM);
  SystemParametersInfo(SPI_GETNONCLIENTMETRICS, SizeOf(NCM),
    @NCM, 0);
  Self.Font.Handle := CreateFontIndirect(NCM.lfMessageFont);
  Image1.Picture.Icon.Handle := LoadIcon(0, IDI_EXCLAMATION);
  // Make sure the buttons are high enough
  H := Canvas.TextHeight('Ay') + 8;
  Inc(H, 8);
  IF btnYes.Height < H THEN
    begin
      btnYes.Height  := H;
      btnNo.Height   := H;
      btnDont.Height := H;
    end;
end;

procedure TDontForm.SetData(const S: String; YesNo: Boolean);
VAR
  B : TButton;
  W : Integer;
  SL : TStringList;
  N : Integer;
  T : Integer;
begin
  IF YesNo THEN
    B := btnNo
  ELSE
    begin
      btnNo.Visible := False;
      btnYes.Caption := 'OK';
      btnDont.Caption := 'OK - don''t show again';
      B := btnYes;
    end;
  // Make sure the big button is wide enough
  W := Canvas.TextWidth(btnDont.Caption) + 8;
  IF W > btnDont.Width THEN
    begin
      // If not, widen it...
      btnDont.Width := W;
      btnDont.Left  := ClientWidth - 8 - W;
      // If that makes it overlap the other buttons, widen the form
      IF btnDont.Left < B.Left + B.Width + 8 THEN
        begin
          btnDont.Left := B.Left + B.Width + 8;
          ClientWidth := btnDont.Left + W + 8;
        end;
    end;
  W := ClientWidth - 55;
  SL := TStringList.Create;
  try
    SL.Text := S;
    T := 8;
    FOR N := 0 TO SL.Count-1 DO
      begin
        WITH TLabel.Create(Self) DO
          begin
            Parent := Self;
            IF N = 0 THEN Font.Style := [fsBold];
            Left := 48;
            Top := T;
            WordWrap := True;
            Width := W;
            Caption := SL[N];
            T := T + Height + 8;
          end;
      end;
  finally
    SL.Free;
  end;
  Inc(T, 8);
  btnYes.Top := T;
  btnNo.Top := T;
  btnDont.Top := T;
  ClientHeight := T + btnDont.Height + 8;
end;

end.
