unit syntaxu;

// Copyright  2001 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls;

type
  TSyntaxForm = class(TForm)
    la1     : TLabel;
    la2     : TLabel;
    la3     : TLabel;
    la4     : TLabel;
    la5     : TLabel;
    la6     : TLabel;
    lb1     : TLabel;
    lb2     : TLabel;
    lb3     : TLabel;
    lb4     : TLabel;
    btnOK   : TButton;
    btnHelp : TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SyntaxForm: TSyntaxForm;

implementation

{$R *.dfm}

{ TSyntaxForm }

procedure TSyntaxForm.FormCreate(Sender: TObject);
VAR
  NCM : NONCLIENTMETRICS;
  X, N : Integer;
begin
  FillChar(NCM, SizeOf(NCM), 0);
  NCM.cbSize := SizeOf(NCM);
  SystemParametersInfo(SPI_GETNONCLIENTMETRICS, SizeOf(NCM),
    @NCM, 0);
  Self.Font.Handle := CreateFontIndirect(NCM.lfMessageFont);
  FOR N := 1 TO 6 DO
    WITH FindComponent('la'+IntToStr(N)) AS TLabel DO
      Font.Style := [fsBold];
  X := la6.Left + la6.Width + 12;
  FOR N := 1 TO 4 DO
    WITH FindComponent('lb'+IntToStr(N)) AS TLabel DO
      Left := X;
  la2.Top := la1.Top + la1.Height + 11;
  la3.Top := la2.Top + la2.Height + 11;
  la4.Top := la3.Top + la3.Height + 3;
  la5.Top := la4.Top + la4.Height + 11;
  la6.Top := la5.Top + la5.Height + 3;
  lb1.Top := la1.Top;
  lb2.Top := la2.Top;
  lb3.Top := la4.Top;
  lb4.Top := la6.Top;
  btnOk.Top         := la6.Top + la6.Height + 11;
  btnHelp.Top       := btnOk.Top;
  Self.ClientHeight := btnOK.Top + btnOK.Height + 8;
  Self.ClientWidth  := lb3.Left  + lb3.Width    + 8;
end;

procedure TSyntaxForm.btnHelpClick(Sender: TObject);
begin
  Application.HelpContext(1);
end;

end.
